<?php 
require_once 'includes/config.php';
requireLogin();

$user_id = $_SESSION['user_id'];

// Get user subscriptions with package details
$stmt = $pdo->prepare("SELECT s.*, p.name as package_name, p.storage, p.bandwidth, p.domains, p.email_accounts 
                       FROM subscriptions s 
                       JOIN packages p ON s.package_id = p.id 
                       WHERE s.user_id = ? 
                       ORDER BY s.is_active DESC, s.end_date DESC");
$stmt->execute([$user_id]);
$subscriptions = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Hosting - Web Hosting Bangladesh</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="logo">
                <a href="index.php"><img src="assets/images/logo.png" alt="Hosting BD Logo"></a>
            </div>
            <nav>
                <ul>
                    <li><a href="index.php">Home</a></li>
                    <li><a href="packages.php">Hosting Packages</a></li>
                    <li><a href="#features">Features</a></li>
                    <li><a href="#support">Support</a></li>
                    <?php if (isLoggedIn()): ?>
                        <li><a href="dashboard.php">Dashboard</a></li>
                        <li><a href="logout.php">Logout</a></li>
                    <?php else: ?>
                        <li><a href="login.php">Login</a></li>
                        <li><a href="register.php">Register</a></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </header>

    <section class="dashboard">
        <div class="container">
            <div class="dashboard-grid">
                <div class="sidebar">
                    <div class="profile">
                        <div class="avatar">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <h3><?php echo htmlspecialchars($_SESSION['user_name']); ?></h3>
                        <p><?php echo htmlspecialchars($_SESSION['user_email']); ?></p>
                    </div>
                    
                    <nav class="dashboard-nav">
                        <ul>
                            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
                            <li class="active"><a href="subscription.php"><i class="fas fa-server"></i> My Hosting</a></li>
                            <li><a href="orders.php"><i class="fas fa-shopping-cart"></i> My Orders</a></li>
                            <li><a href="profile.php"><i class="fas fa-user"></i> Profile</a></li>
                            <li><a href="payment-methods.php"><i class="fas fa-credit-card"></i> Payment Methods</a></li>
                            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                        </ul>
                    </nav>
                </div>
                
                <div class="main-content">
                    <h2>My Hosting Subscriptions</h2>
                    
                    <?php if (empty($subscriptions)): ?>
                        <div class="alert alert-info">
                            <p>You don't have any active hosting subscriptions. <a href="packages.php">Browse our hosting packages</a> to get started.</p>
                        </div>
                    <?php else: ?>
                        <div class="subscriptions-grid">
                            <?php foreach ($subscriptions as $subscription): ?>
                            <div class="subscription-card <?php echo $subscription['is_active'] ? 'active' : 'expired'; ?>">
                                <div class="subscription-header">
                                    <h3><?php echo htmlspecialchars($subscription['package_name']); ?></h3>
                                    <span class="status-badge <?php echo $subscription['is_active'] ? 'active' : 'expired'; ?>">
                                        <?php echo $subscription['is_active'] ? 'Active' : 'Expired'; ?>
                                    </span>
                                </div>
                                
                                <div class="subscription-details">
                                    <ul>
                                        <li><?php echo htmlspecialchars($subscription['storage']); ?> Storage</li>
                                        <li><?php echo htmlspecialchars($subscription['bandwidth']); ?> Bandwidth</li>
                                        <li><?php echo $subscription['domains']; ?> Domains</li>
                                        <li><?php echo $subscription['email_accounts']; ?> Email Accounts</li>
                                    </ul>
                                    
                                    <div class="subscription-dates">
                                        <div class="date-row">
                                            <span>Start Date:</span>
                                            <span><?php echo date('M d, Y', strtotime($subscription['start_date'])); ?></span>
                                        </div>
                                        <div class="date-row">
                                            <span>End Date:</span>
                                            <span><?php echo date('M d, Y', strtotime($subscription['end_date'])); ?></span>
                                        </div>
                                        <div class="date-row">
                                            <span>Remaining:</span>
                                            <span>
                                                <?php 
                                                if ($subscription['is_active']) {
                                                    $diff = date_diff(date_create(), date_create($subscription['end_date']));
                                                    echo $diff->format('%a days');
                                                } else {
                                                    echo 'Expired';
                                                }
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="subscription-actions">
                                    <?php if ($subscription['is_active']): ?>
                                        <a href="renew.php?subscription_id=<?php echo $subscription['id']; ?>" class="btn btn-sm">Renew</a>
                                        <a href="cpanel.php?subscription_id=<?php echo $subscription['id']; ?>" class="btn btn-sm btn-primary">cPanel</a>
                                    <?php else: ?>
                                        <a href="order.php?package_id=<?php echo $subscription['package_id']; ?>" class="btn btn-sm">Order Again</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-col">
                    <h3>Hosting BD</h3>
                    <p>Providing affordable and reliable web hosting solutions in Bangladesh since 2023.</p>
                </div>
                <div class="footer-col">
                    <h3>Quick Links</h3>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="packages.php">Hosting Packages</a></li>
                        <li><a href="#features">Features</a></li>
                        <li><a href="#support">Support</a></li>
                    </ul>
                </div>
                <div class="footer-col">
                    <h3>Contact Us</h3>
                    <ul>
                        <li><i class="fas fa-phone"></i> +880 1XXX-XXXXXX</li>
                        <li><i class="fas fa-envelope"></i> support@hostingbd.com</li>
                        <li><i class="fas fa-map-marker-alt"></i> Dhaka, Bangladesh</li>
                    </ul>
                </div>
            </div>
            <div class="copyright">
                <p>&copy; <?php echo date('Y'); ?> Hosting BD. All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/js/script.js"></script>
</body>
</html>