<?php 
require_once 'includes/config.php';
requireLogin();

$user_id = $_SESSION['user_id'];

// Handle payment method update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $payment_method = $_POST['payment_method'];
    
    try {
        $stmt = $pdo->prepare("UPDATE users SET payment_method = ? WHERE id = ?");
        $stmt->execute([$payment_method, $user_id]);
        
        $_SESSION['success'] = "Payment method updated successfully";
    } catch (PDOException $e) {
        $error = "Error updating payment method: " . $e->getMessage();
    }
}

// Get current user data
$stmt = $pdo->prepare("SELECT payment_method FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Methods - Web Hosting Bangladesh</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="logo">
                <a href="index.php"><img src="assets/images/logo.png" alt="Hosting BD Logo"></a>
            </div>
            <nav>
                <ul>
                    <li><a href="index.php">Home</a></li>
                    <li><a href="packages.php">Hosting Packages</a></li>
                    <li><a href="#features">Features</a></li>
                    <li><a href="#support">Support</a></li>
                    <?php if (isLoggedIn()): ?>
                        <li><a href="dashboard.php">Dashboard</a></li>
                        <li><a href="logout.php">Logout</a></li>
                    <?php else: ?>
                        <li><a href="login.php">Login</a></li>
                        <li><a href="register.php">Register</a></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </header>

    <section class="dashboard">
        <div class="container">
            <div class="dashboard-grid">
                <div class="sidebar">
                    <div class="profile">
                        <div class="avatar">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <h3><?php echo htmlspecialchars($_SESSION['user_name']); ?></h3>
                        <p><?php echo htmlspecialchars($_SESSION['user_email']); ?></p>
                    </div>
                    
                    <nav class="dashboard-nav">
                        <ul>
                            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
                            <li><a href="subscription.php"><i class="fas fa-server"></i> My Hosting</a></li>
                            <li><a href="orders.php"><i class="fas fa-shopping-cart"></i> My Orders</a></li>
                            <li><a href="profile.php"><i class="fas fa-user"></i> Profile</a></li>
                            <li class="active"><a href="payment-methods.php"><i class="fas fa-credit-card"></i> Payment Methods</a></li>
                            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                        </ul>
                    </nav>
                </div>
                
                <div class="main-content">
                    <h2>Payment Methods</h2>
                    
                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="alert alert-success">
                            <p><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger">
                            <p><?php echo $error; ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <div class="payment-methods-form">
                        <form action="payment-methods.php" method="POST">
                            <div class="form-group">
                                <label>Select Default Payment Method</label>
                                <div class="payment-methods-grid">
                                    <label class="payment-method-card <?php echo ($user['payment_method'] ?? '') === 'bkash' ? 'active' : ''; ?>">
                                        <input type="radio" name="payment_method" value="bkash" <?php echo ($user['payment_method'] ?? '') === 'bkash' ? 'checked' : ''; ?> required>
                                        <img src="assets/images/bkash.png" alt="bKash">
                                        <span>bKash</span>
                                    </label>
                                    
                                    <label class="payment-method-card <?php echo ($user['payment_method'] ?? '') === 'nagad' ? 'active' : ''; ?>">
                                        <input type="radio" name="payment_method" value="nagad" <?php echo ($user['payment_method'] ?? '') === 'nagad' ? 'checked' : ''; ?>>
                                        <img src="assets/images/nagad.png" alt="Nagad">
                                        <span>Nagad</span>
                                    </label>
                                    
                                    <label class="payment-method-card <?php echo ($user['payment_method'] ?? '') === 'rocket' ? 'active' : ''; ?>">
                                        <input type="radio" name="payment_method" value="rocket" <?php echo ($user['payment_method'] ?? '') === 'rocket' ? 'checked' : ''; ?>>
                                        <img src="assets/images/rocket.png" alt="Rocket">
                                        <span>Rocket</span>
                                    </label>
                                    
                                    <label class="payment-method-card <?php echo ($user['payment_method'] ?? '') === 'card' ? 'active' : ''; ?>">
                                        <input type="radio" name="payment_method" value="card" <?php echo ($user['payment_method'] ?? '') === 'card' ? 'checked' : ''; ?>>
                                        <img src="assets/images/card.png" alt="Credit/Debit Card">
                                        <span>Credit/Debit Card</span>
                                    </label>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Save Payment Method</button>
                        </form>
                    </div>
                    
                    <div class="payment-history">
                        <h3>Recent Transactions</h3>
                        
                        <?php
                        $stmt = $pdo->prepare("SELECT * FROM deposits WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
                        $stmt->execute([$user_id]);
                        $transactions = $stmt->fetchAll();
                        ?>
                        
                        <?php if (empty($transactions)): ?>
                            <p>No transactions found.</p>
                        <?php else: ?>
                            <table>
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Amount</th>
                                        <th>Method</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($transactions as $transaction): ?>
                                    <tr>
                                        <td><?php echo date('M d, Y', strtotime($transaction['created_at'])); ?></td>
                                        <td>৳<?php echo number_format($transaction['amount'], 2); ?></td>
                                        <td>
                                            <?php 
                                            $method_names = [
                                                'bkash' => 'bKash',
                                                'nagad' => 'Nagad',
                                                'rocket' => 'Rocket',
                                                'card' => 'Card'
                                            ];
                                            echo $method_names[$transaction['payment_method']] ?? $transaction['payment_method']; 
                                            ?>
                                        </td>
                                        <td>
                                            <span class="status-badge <?php echo $transaction['status']; ?>">
                                                <?php echo ucfirst($transaction['status']); ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            
                            <div class="text-right">
                                <a href="transactions.php" class="btn btn-outline">View All Transactions</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-col">
                    <h3>Hosting BD</h3>
                    <p>Providing affordable and reliable web hosting solutions in Bangladesh since 2023.</p>
                </div>
                <div class="footer-col">
                    <h3>Quick Links</h3>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="packages.php">Hosting Packages</a></li>
                        <li><a href="#features">Features</a></li>
                        <li><a href="#support">Support</a></li>
                    </ul>
                </div>
                <div class="footer-col">
                    <h3>Contact Us</h3>
                    <ul>
                        <li><i class="fas fa-phone"></i> +880 1XXX-XXXXXX</li>
                        <li><i class="fas fa-envelope"></i> support@hostingbd.com</li>
                        <li><i class="fas fa-map-marker-alt"></i> Dhaka, Bangladesh</li>
                    </ul>
                </div>
            </div>
            <div class="copyright">
                <p>&copy; <?php echo date('Y'); ?> Hosting BD. All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/js/script.js"></script>
</body>
</html>