<?php 
require_once 'includes/config.php';
requireLogin();

if (!isset($_GET['package_id'])) {
    header('Location: packages.php');
    exit();
}

$package_id = $_GET['package_id'];
$package = getPackage($package_id);

if (!$package) {
    header('Location: packages.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $payment_method = $_POST['payment_method'];
    
    // Create order
    $order_id = createOrder($_SESSION['user_id'], $package_id, $package['price'], $payment_method);
    
    if ($order_id) {
        header("Location: payment.php?order_id=$order_id");
        exit();
    } else {
        $error = "Failed to create order. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Hosting - Web Hosting Bangladesh</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="logo">
                <a href="index.php"><img src="assets/images/logo.png" alt="Hosting BD Logo"></a>
            </div>
            <nav>
                <ul>
                    <li><a href="index.php">Home</a></li>
                    <li><a href="packages.php">Hosting Packages</a></li>
                    <li><a href="#features">Features</a></li>
                    <li><a href="#support">Support</a></li>
                    <?php if (isLoggedIn()): ?>
                        <li><a href="dashboard.php">Dashboard</a></li>
                        <li><a href="logout.php">Logout</a></li>
                    <?php else: ?>
                        <li><a href="login.php">Login</a></li>
                        <li><a href="register.php">Register</a></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </header>

    <section class="order-page">
        <div class="container">
            <div class="order-steps">
                <div class="step active">
                    <span>1</span>
                    <p>Choose Package</p>
                </div>
                <div class="step active">
                    <span>2</span>
                    <p>Configure</p>
                </div>
                <div class="step">
                    <span>3</span>
                    <p>Payment</p>
                </div>
                <div class="step">
                    <span>4</span>
                    <p>Complete</p>
                </div>
            </div>
            
            <div class="order-grid">
                <div class="order-summary">
                    <h3>Order Summary</h3>
                    <div class="package-card">
                        <h4><?php echo htmlspecialchars($package['name']); ?></h4>
                        <div class="price">৳<?php echo number_format($package['price'], 2); ?>/month</div>
                        <ul>
                            <li><?php echo htmlspecialchars($package['storage']); ?> Storage</li>
                            <li><?php echo htmlspecialchars($package['bandwidth']); ?> Bandwidth</li>
                            <li><?php echo $package['domains']; ?> Domains</li>
                            <li><?php echo $package['email_accounts']; ?> Email Accounts</li>
                            <li>Free SSL Certificate</li>
                            <li>24/7 Support</li>
                        </ul>
                    </div>
                    
                    <div class="billing-cycle">
                        <h4>Billing Cycle</h4>
                        <div class="cycle-options">
                            <label class="active">
                                <input type="radio" name="billing_cycle" value="monthly" checked>
                                Monthly
                            </label>
                            <label>
                                <input type="radio" name="billing_cycle" value="quarterly">
                                Quarterly (Save 10%)
                            </label>
                            <label>
                                <input type="radio" name="billing_cycle" value="yearly">
                                Yearly (Save 20%)
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="order-form">
                    <h3>Payment Method</h3>
                    
                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger">
                            <p><?php echo $error; ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <form action="order.php?package_id=<?php echo $package_id; ?>" method="POST">
                        <div class="form-group">
                            <label>Select Payment Method</label>
                            <div class="payment-methods">
                                <label>
                                    <input type="radio" name="payment_method" value="bkash" required checked>
                                    <img src="assets/images/bkash.png" alt="bKash">
                                </label>
                                <label>
                                    <input type="radio" name="payment_method" value="nagad">
                                    <img src="assets/images/nagad.png" alt="Nagad">
                                </label>
                                <label>
                                    <input type="radio" name="payment_method" value="rocket">
                                    <img src="assets/images/rocket.png" alt="Rocket">
                                </label>
                                <label>
                                    <input type="radio" name="payment_method" value="card">
                                    <img src="assets/images/card.png" alt="Credit/Debit Card">
                                </label>
                                <label>
                                    <input type="radio" name="payment_method" value="balance">
                                    <img src="assets/images/wallet.png" alt="Account Balance">
                                    <span>Use Account Balance (৳<?php echo number_format(getUserBalance($_SESSION['user_id']), 2); ?>)</span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="promo_code">Promo Code (Optional)</label>
                            <input type="text" id="promo_code" name="promo_code" placeholder="Enter promo code">
                        </div>
                        
                        <div class="order-total">
                            <div class="total-row">
                                <span>Subtotal:</span>
                                <span>৳<?php echo number_format($package['price'], 2); ?></span>
                            </div>
                            <div class="total-row">
                                <span>Discount:</span>
                                <span>-৳0.00</span>
                            </div>
                            <div class="total-row grand-total">
                                <span>Total:</span>
                                <span>৳<?php echo number_format($package['price'], 2); ?></span>
                            </div>
                        </div>
                        
                        <div class="form-group terms">
                            <label>
                                <input type="checkbox" name="terms" required>
                                I agree to the <a href="terms.php">Terms of Service</a> and <a href="privacy.php">Privacy Policy</a>
                            </label>
                        </div>
                        
                        <button type="submit" class="btn btn-block">Continue to Payment</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-col">
                    <h3>Hosting BD</h3>
                    <p>Providing affordable and reliable web hosting solutions in Bangladesh since 2023.</p>
                </div>
                <div class="footer-col">
                    <h3>Quick Links</h3>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="packages.php">Hosting Packages</a></li>
                        <li><a href="#features">Features</a></li>
                        <li><a href="#support">Support</a></li>
                    </ul>
                </div>
                <div class="footer-col">
                    <h3>Contact Us</h3>
                    <ul>
                        <li><i class="fas fa-phone"></i> +880 1XXX-XXXXXX</li>
                        <li><i class="fas fa-envelope"></i> support@hostingbd.com</li>
                        <li><i class="fas fa-map-marker-alt"></i> Dhaka, Bangladesh</li>
                    </ul>
                </div>
            </div>
            <div class="copyright">
                <p>&copy; <?php echo date('Y'); ?> Hosting BD. All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/js/script.js"></script>
    <script>
        // Update total price based on billing cycle selection
        document.querySelectorAll('input[name="billing_cycle"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const basePrice = <?php echo $package['price']; ?>;
                let price = basePrice;
                let discount = 0;
                
                if (this.value === 'quarterly') {
                    price = basePrice * 3 * 0.9; // 10% discount
                    discount = basePrice * 3 * 0.1;
                } else if (this.value === 'yearly') {
                    price = basePrice * 12 * 0.8; // 20% discount
                    discount = basePrice * 12 * 0.2;
                }
                
                document.querySelector('.order-total .total-row:nth-child(1) span:last-child').textContent = 
                    '৳' + price.toFixed(2);
                document.querySelector('.order-total .total-row:nth-child(2) span:last-child').textContent = 
                    '-৳' + discount.toFixed(2);
                document.querySelector('.order-total .grand-total span:last-child').textContent = 
                    '৳' + price.toFixed(2);
            });
        });
    </script>
</body>
</html>