// Mobile Menu Toggle
document.addEventListener('DOMContentLoaded', function() {
    // Mobile menu toggle
    const mobileMenuBtn = document.createElement('button');
    mobileMenuBtn.className = 'mobile-menu-btn';
    mobileMenuBtn.innerHTML = '<i class="fas fa-bars"></i>';
    
    const header = document.querySelector('header .container');
    if (header) {
        header.prepend(mobileMenuBtn);
        
        const nav = document.querySelector('nav');
        mobileMenuBtn.addEventListener('click', function() {
            nav.classList.toggle('active');
        });
    }
    
    // Admin mobile menu toggle
    const adminMobileMenuBtn = document.createElement('button');
    adminMobileMenuBtn.className = 'admin-mobile-menu-btn';
    adminMobileMenuBtn.innerHTML = '<i class="fas fa-bars"></i>';
    
    const adminHeader = document.querySelector('.admin-header');
    if (adminHeader) {
        adminHeader.prepend(adminMobileMenuBtn);
        
        const adminSidebar = document.querySelector('.admin-sidebar');
        adminMobileMenuBtn.addEventListener('click', function() {
            adminSidebar.classList.toggle('active');
        });
    }
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let isValid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    isValid = false;
                    field.classList.add('error');
                } else {
                    field.classList.remove('error');
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                alert('Please fill in all required fields.');
            }
        });
    });
    
    // Alert close buttons
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        const closeBtn = document.createElement('button');
        closeBtn.className = 'alert-close';
        closeBtn.innerHTML = '<i class="fas fa-times"></i>';
        closeBtn.addEventListener('click', function() {
            alert.remove();
        });
        alert.appendChild(closeBtn);
    });
    
    // Payment method selection
    const paymentMethods = document.querySelectorAll('.payment-methods input[type="radio"]');
    paymentMethods.forEach(method => {
        method.addEventListener('change', function() {
            document.querySelectorAll('.payment-methods label').forEach(label => {
                label.classList.remove('active');
            });
            
            if (this.checked) {
                this.parentElement.classList.add('active');
            }
        });
    });
    
    // Billing cycle selection
    const billingCycles = document.querySelectorAll('.cycle-options input[type="radio"]');
    billingCycles.forEach(cycle => {
        cycle.addEventListener('change', function() {
            document.querySelectorAll('.cycle-options label').forEach(label => {
                label.classList.remove('active');
            });
            
            if (this.checked) {
                this.nextElementSibling.classList.add('active');
            }
        });
    });
    
    // Initialize tooltips
    const tooltips = document.querySelectorAll('[data-tooltip]');
    tooltips.forEach(tooltip => {
        tooltip.addEventListener('mouseenter', function() {
            const tooltipText = this.getAttribute('data-tooltip');
            const tooltipElement = document.createElement('div');
            tooltipElement.className = 'tooltip';
            tooltipElement.textContent = tooltipText;
            document.body.appendChild(tooltipElement);
            
            const rect = this.getBoundingClientRect();
            tooltipElement.style.left = `${rect.left + rect.width / 2 - tooltipElement.offsetWidth / 2}px`;
            tooltipElement.style.top = `${rect.top - tooltipElement.offsetHeight - 10}px`;
            
            this.addEventListener('mouseleave', function() {
                tooltipElement.remove();
            });
        });
    });
});

// Password strength indicator
function checkPasswordStrength(password) {
    let strength = 0;
    
    if (password.length >= 8) strength++;
    if (password.match(/[a-z]/) strength++;
    if (password.match(/[A-Z]/)) strength++;
    if (password.match(/[0-9]/)) strength++;
    if (password.match(/[^a-zA-Z0-9]/)) strength++;
    
    return strength;
}

document.querySelectorAll('input[type="password"]').forEach(input => {
    input.addEventListener('input', function() {
        const strength = checkPasswordStrength(this.value);
        const strengthMeter = this.nextElementSibling;
        
        if (strengthMeter && strengthMeter.classList.contains('password-strength')) {
            strengthMeter.innerHTML = '';
            
            for (let i = 0; i < 5; i++) {
                const bar = document.createElement('span');
                bar.style.backgroundColor = i < strength ? 
                    (strength < 3 ? 'red' : strength < 5 ? 'orange' : 'green') : '#ddd';
                strengthMeter.appendChild(bar);
            }
        }
    });
});

// Responsive tables
function makeTablesResponsive() {
    const tables = document.querySelectorAll('table');
    
    tables.forEach(table => {
        const wrapper = document.createElement('div');
        wrapper.className = 'table-responsive';
        table.parentNode.insertBefore(wrapper, table);
        wrapper.appendChild(table);
    });
}

window.addEventListener('resize', makeTablesResponsive);
makeTablesResponsive();