<?php require_once 'includes/config.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Web Hosting Bangladesh - Affordable Hosting Solutions</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="logo">
                <a href="index.php"><img src="assets/images/logo.png" alt="Hosting BD Logo"></a>
            </div>
            <nav>
                <ul>
                    <li><a href="index.php">Home</a></li>
                    <li><a href="packages.php">Hosting Packages</a></li>
                    <li><a href="#features">Features</a></li>
                    <li><a href="#support">Support</a></li>
                    <?php if (isLoggedIn()): ?>
                        <li><a href="dashboard.php">Dashboard</a></li>
                        <li><a href="logout.php">Logout</a></li>
                    <?php else: ?>
                        <li><a href="login.php">Login</a></li>
                        <li><a href="register.php">Register</a></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </header>

    <section class="hero">
        <div class="container">
            <h1>Affordable Web Hosting in Bangladesh</h1>
            <p>Get started with our reliable hosting solutions starting at just ৳99/month</p>
            <a href="packages.php" class="btn">View Packages</a>
        </div>
    </section>

    <section id="features" class="features">
        <div class="container">
            <h2>Why Choose Our Hosting?</h2>
            <div class="feature-grid">
                <div class="feature-item">
                    <i class="fas fa-server"></i>
                    <h3>99.9% Uptime</h3>
                    <p>Our servers are monitored 24/7 to ensure maximum uptime for your website.</p>
                </div>
                <div class="feature-item">
                    <i class="fas fa-shield-alt"></i>
                    <h3>Free SSL</h3>
                    <p>Every hosting plan comes with a free SSL certificate to secure your website.</p>
                </div>
                <div class="feature-item">
                    <i class="fas fa-headset"></i>
                    <h3>24/7 Support</h3>
                    <p>Our expert support team is available round the clock to assist you.</p>
                </div>
                <div class="feature-item">
                    <i class="fas fa-money-bill-wave"></i>
                    <h3>BDT Payment</h3>
                    <p>Pay in Bangladeshi Taka using bKash, Rocket, Nagad and other local methods.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="popular-packages">
        <div class="container">
            <h2>Popular Hosting Packages</h2>
            <div class="package-grid">
                <?php 
                $packages = getPackages();
                foreach (array_slice($packages, 0, 3) as $package): 
                ?>
                <div class="package-item">
                    <h3><?php echo htmlspecialchars($package['name']); ?></h3>
                    <div class="price">৳<?php echo number_format($package['price'], 2); ?>/month</div>
                    <ul>
                        <li><?php echo htmlspecialchars($package['storage']); ?> Storage</li>
                        <li><?php echo htmlspecialchars($package['bandwidth']); ?> Bandwidth</li>
                        <li><?php echo $package['domains']; ?> Domains</li>
                        <li><?php echo $package['email_accounts']; ?> Email Accounts</li>
                    </ul>
                    <a href="order.php?package_id=<?php echo $package['id']; ?>" class="btn">Order Now</a>
                </div>
                <?php endforeach; ?>
            </div>
            <div class="text-center">
                <a href="packages.php" class="btn btn-outline">View All Packages</a>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-col">
                    <h3>Hosting BD</h3>
                    <p>Providing affordable and reliable web hosting solutions in Bangladesh since 2023.</p>
                </div>
                <div class="footer-col">
                    <h3>Quick Links</h3>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="packages.php">Hosting Packages</a></li>
                        <li><a href="#features">Features</a></li>
                        <li><a href="#support">Support</a></li>
                    </ul>
                </div>
                <div class="footer-col">
                    <h3>Contact Us</h3>
                    <ul>
                        <li><i class="fas fa-phone"></i> +880 1XXX-XXXXXX</li>
                        <li><i class="fas fa-envelope"></i> support@hostingbd.com</li>
                        <li><i class="fas fa-map-marker-alt"></i> Dhaka, Bangladesh</li>
                    </ul>
                </div>
            </div>
            <div class="copyright">
                <p>&copy; <?php echo date('Y'); ?> Hosting BD. All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/js/script.js"></script>
</body>
</html>