<?php
// Register a new user
function registerUser($name, $email, $password, $phone, $payment_method) {
    global $pdo;
    
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    
    $stmt = $pdo->prepare("INSERT INTO users (name, email, password, phone, payment_method) VALUES (?, ?, ?, ?, ?)");
    return $stmt->execute([$name, $email, $hashed_password, $phone, $payment_method]);
}

// Login user
function loginUser($email, $password) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_email'] = $user['email'];
        $_SESSION['user_name'] = $user['name'];
        $_SESSION['is_admin'] = ($user['email'] === 'admin@example.com'); // Simple admin check
        
        return true;
    }
    
    return false;
}

// Get all hosting packages
function getPackages() {
    global $pdo;
    
    $stmt = $pdo->query("SELECT * FROM packages WHERE is_active = TRUE");
    return $stmt->fetchAll();
}

// Get package by ID
function getPackage($id) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT * FROM packages WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

// Create a new order
function createOrder($user_id, $package_id, $amount, $payment_method) {
    global $pdo;
    
    $stmt = $pdo->prepare("INSERT INTO orders (user_id, package_id, amount, payment_method) VALUES (?, ?, ?, ?)");
    $stmt->execute([$user_id, $package_id, $amount, $payment_method]);
    
    return $pdo->lastInsertId();
}

// Get user orders
function getUserOrders($user_id) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT o.*, p.name as package_name FROM orders o JOIN packages p ON o.package_id = p.id WHERE o.user_id = ? ORDER BY o.created_at DESC");
    $stmt->execute([$user_id]);
    return $stmt->fetchAll();
}

// Update order status
function updateOrderStatus($order_id, $status) {
    global $pdo;
    
    $stmt = $pdo->prepare("UPDATE orders SET status = ? WHERE id = ?");
    return $stmt->execute([$status, $order_id]);
}

// Get user balance
function getUserBalance($user_id) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT balance FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    
    return $user ? $user['balance'] : 0;
}

// Update user balance
function updateUserBalance($user_id, $amount) {
    global $pdo;
    
    $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
    return $stmt->execute([$amount, $user_id]);
}

// Admin functions
function getAllUsers() {
    global $pdo;
    
    $stmt = $pdo->query("SELECT * FROM users ORDER BY created_at DESC");
    return $stmt->fetchAll();
}

function getAllOrders() {
    global $pdo;
    
    $stmt = $pdo->query("SELECT o.*, u.name as user_name, p.name as package_name FROM orders o JOIN users u ON o.user_id = u.id JOIN packages p ON o.package_id = p.id ORDER BY o.created_at DESC");
    return $stmt->fetchAll();
}

function createPackage($name, $description, $price, $storage, $bandwidth, $domains, $email_accounts) {
    global $pdo;
    
    $stmt = $pdo->prepare("INSERT INTO packages (name, description, price, storage, bandwidth, domains, email_accounts) VALUES (?, ?, ?, ?, ?, ?, ?)");
    return $stmt->execute([$name, $description, $price, $storage, $bandwidth, $domains, $email_accounts]);
}

function updatePackage($id, $name, $description, $price, $storage, $bandwidth, $domains, $email_accounts, $is_active) {
    global $pdo;
    
    $stmt = $pdo->prepare("UPDATE packages SET name = ?, description = ?, price = ?, storage = ?, bandwidth = ?, domains = ?, email_accounts = ?, is_active = ? WHERE id = ?");
    return $stmt->execute([$name, $description, $price, $storage, $bandwidth, $domains, $email_accounts, $is_active, $id]);
}

function getSalesReport() {
    global $pdo;
    
    $stmt = $pdo->query("SELECT 
        COUNT(*) as total_orders,
        SUM(amount) as total_revenue,
        SUM(CASE WHEN status = 'completed' THEN amount ELSE 0 END) as completed_revenue,
        SUM(CASE WHEN status = 'pending' THEN amount ELSE 0 END) as pending_revenue
        FROM orders");
    return $stmt->fetch();
}
?>