<?php 
require_once 'includes/config.php';
requireLogin();

$user_id = $_SESSION['user_id'];

// Handle deposit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = (float)$_POST['amount'];
    $payment_method = $_POST['payment_method'];
    $transaction_id = trim($_POST['transaction_id']);
    
    // Validate inputs
    $errors = [];
    
    if ($amount <= 0) {
        $errors[] = "Amount must be greater than 0";
    }
    
    if (empty($payment_method)) {
        $errors[] = "Payment method is required";
    }
    
    if (empty($transaction_id) && $payment_method !== 'balance') {
        $errors[] = "Transaction ID is required";
    }
    
    if (empty($errors)) {
        // Create deposit record (in a real app, you'd verify the payment first)
        $stmt = $pdo->prepare("INSERT INTO deposits (user_id, amount, payment_method, transaction_id, status) VALUES (?, ?, ?, ?, 'completed')");
        $stmt->execute([$user_id, $amount, $payment_method, $transaction_id]);
        
        // Update user balance
        updateUserBalance($user_id, $amount);
        
        $_SESSION['success'] = "Deposit successful! Your account balance has been updated.";
        header('Location: dashboard.php');
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit Funds - Web Hosting Bangladesh</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="logo">
                <a href="index.php"><img src="assets/images/logo.png" alt="Hosting BD Logo"></a>
            </div>
            <nav>
                <ul>
                    <li><a href="index.php">Home</a></li>
                    <li><a href="packages.php">Hosting Packages</a></li>
                    <li><a href="#features">Features</a></li>
                    <li><a href="#support">Support</a></li>
                    <?php if (isLoggedIn()): ?>
                        <li><a href="dashboard.php">Dashboard</a></li>
                        <li><a href="logout.php">Logout</a></li>
                    <?php else: ?>
                        <li><a href="login.php">Login</a></li>
                        <li><a href="register.php">Register</a></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </header>

    <section class="dashboard">
        <div class="container">
            <div class="dashboard-grid">
                <div class="sidebar">
                    <div class="profile">
                        <div class="avatar">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <h3><?php echo htmlspecialchars($_SESSION['user_name']); ?></h3>
                        <p><?php echo htmlspecialchars($_SESSION['user_email']); ?></p>
                    </div>
                    
                    <nav class="dashboard-nav">
                        <ul>
                            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
                            <li><a href="subscription.php"><i class="fas fa-server"></i> My Hosting</a></li>
                            <li><a href="orders.php"><i class="fas fa-shopping-cart"></i> My Orders</a></li>
                            <li><a href="profile.php"><i class="fas fa-user"></i> Profile</a></li>
                            <li><a href="payment-methods.php"><i class="fas fa-credit-card"></i> Payment Methods</a></li>
                            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                        </ul>
                    </nav>
                </div>
                
                <div class="main-content">
                    <h2>Deposit Funds</h2>
                    
                    <?php if (isset($errors) && !empty($errors)): ?>
                        <div class="alert alert-danger">
                            <?php foreach ($errors as $error): ?>
                                <p><?php echo $error; ?></p>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="deposit-form">
                        <form action="deposit.php" method="POST">
                            <div class="form-group">
                                <label for="amount">Amount (৳)</label>
                                <input type="number" id="amount" name="amount" min="1" step="0.01" required>
                            </div>
                            
                            <div class="form-group">
                                <label>Payment Method</label>
                                <div class="payment-methods">
                                    <label>
                                        <input type="radio" name="payment_method" value="bkash" required checked>
                                        <img src="assets/images/bkash.png" alt="bKash">
                                    </label>
                                    <label>
                                        <input type="radio" name="payment_method" value="nagad">
                                        <img src="assets/images/nagad.png" alt="Nagad">
                                    </label>
                                    <label>
                                        <input type="radio" name="payment_method" value="rocket">
                                        <img src="assets/images/rocket.png" alt="Rocket">
                                    </label>
                                    <label>
                                        <input type="radio" name="payment_method" value="card">
                                        <img src="assets/images/card.png" alt="Credit/Debit Card">
                                    </label>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="transaction_id">Transaction ID</label>
                                <input type="text" id="transaction_id" name="transaction_id" placeholder="Enter transaction ID">
                                <small>Required for bKash/Nagad/Rocket payments</small>
                            </div>
                            
                            <div class="payment-instructions">
                                <h4>Payment Instructions</h4>
                                <div class="instructions">
                                    <p>1. Send money to our account using your preferred payment method</p>
                                    <p>2. Enter the transaction ID in the form above</p>
                                    <p>3. Your account balance will be updated after verification</p>
                                    <p><strong>Our bKash/Nagad/Rocket Number: 01XXXXXXXXX</strong></p>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary btn-block">Complete Deposit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-col">
                    <h3>Hosting BD</h3>
                    <p>Providing affordable and reliable web hosting solutions in Bangladesh since 2023.</p>
                </div>
                <div class="footer-col">
                    <h3>Quick Links</h3>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="packages.php">Hosting Packages</a></li>
                        <li><a href="#features">Features</a></li>
                        <li><a href="#support">Support</a></li>
                    </ul>
                </div>
                <div class="footer-col">
                    <h3>Contact Us</h3>
                    <ul>
                        <li><i class="fas fa-phone"></i> +880 1XXX-XXXXXX</li>
                        <li><i class="fas fa-envelope"></i> support@hostingbd.com</li>
                        <li><i class="fas fa-map-marker-alt"></i> Dhaka, Bangladesh</li>
                    </ul>
                </div>
            </div>
            <div class="copyright">
                <p>&copy; <?php echo date('Y'); ?> Hosting BD. All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/js/script.js"></script>
</body>
</html>