<?php 
require_once '../includes/config.php';
requireAdmin();

// Handle balance update
if (isset($_POST['update_balance'])) {
    $user_id = (int)$_POST['user_id'];
    $amount = (float)$_POST['amount'];
    $action = $_POST['action'];
    
    if ($action === 'add') {
        updateUserBalance($user_id, $amount);
        $_SESSION['success'] = "Balance added successfully";
    } elseif ($action === 'deduct') {
        updateUserBalance($user_id, -$amount);
        $_SESSION['success'] = "Balance deducted successfully";
    }
    
    header('Location: users.php');
    exit();
}

// Get all users
$users = getAllUsers();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Users - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="admin-content">
            <header class="admin-header">
                <h1>Manage Users</h1>
                <div class="admin-user">
                    <span><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                    <div class="avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                </div>
            </header>
            
            <?php if (isset($_SESSION['success'])): ?>
                <div class="alert alert-success">
                    <p><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></p>
                </div>
            <?php endif; ?>
            
            <div class="admin-sections">
                <section class="admin-section">
                    <div class="section-header">
                        <h2>All Users</h2>
                    </div>
                    
                    <?php if (empty($users)): ?>
                        <p>No users found.</p>
                    <?php else: ?>
                        <table class="admin-table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Balance</th>
                                    <th>Joined</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($user['name']); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['phone']); ?></td>
                                    <td>৳<?php echo number_format($user['balance'], 2); ?></td>
                                    <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
                                    <td>
                                        <a href="user-details.php?id=<?php echo $user['id']; ?>" class="btn btn-sm">View</a>
                                        <button class="btn btn-sm btn-primary" onclick="openBalanceModal(<?php echo $user['id']; ?>, '<?php echo htmlspecialchars($user['name']); ?>')">Balance</button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </section>
            </div>
        </main>
    </div>
    
    <!-- Balance Update Modal -->
    <div id="balanceModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2>Update Balance for <span id="userName"></span></h2>
            
            <form action="users.php" method="POST">
                <input type="hidden" id="userId" name="user_id">
                
                <div class="admin-form-group">
                    <label for="action">Action</label>
                    <select id="action" name="action" required>
                        <option value="add">Add Balance</option>
                        <option value="deduct">Deduct Balance</option>
                    </select>
                </div>
                
                <div class="admin-form-group">
                    <label for="amount">Amount (৳)</label>
                    <input type="number" id="amount" name="amount" step="0.01" min="0" required>
                </div>
                
                <div class="admin-form-actions">
                    <button type="submit" name="update_balance" class="btn btn-primary">Update Balance</button>
                </div>
            </form>
        </div>
    </div>

    <script src="../assets/js/script.js"></script>
    <script>
        function openBalanceModal(userId, userName) {
            document.getElementById('userId').value = userId;
            document.getElementById('userName').textContent = userName;
            document.getElementById('balanceModal').style.display = 'block';
        }
        
        function closeModal() {
            document.getElementById('balanceModal').style.display = 'none';
        }
        
        // Close modal when clicking outside
        window.onclick = function(event) {
            const modal = document.getElementById('balanceModal');
            if (event.target === modal) {
                modal.style.display = 'none';
            }
        }
    </script>
</body>
</html>