<?php 
require_once '../includes/config.php';
requireAdmin();

// Get sales report
$sales_report = getSalesReport();

// Get recent orders
$recent_orders = getAllOrders(10);

// Get recent users
$recent_users = getAllUsers(10);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="admin-content">
            <header class="admin-header">
                <h1>Reports & Statistics</h1>
                <div class="admin-user">
                    <span><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                    <div class="avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                </div>
            </header>
            
            <div class="admin-sections">
                <section class="admin-section">
                    <div class="section-header">
                        <h2>Sales Overview</h2>
                    </div>
                    
                    <div class="admin-stats">
                        <div class="admin-stat">
                            <div class="admin-stat-icon">
                                <i class="fas fa-shopping-cart"></i>
                            </div>
                            <div class="admin-stat-value"><?php echo $sales_report['total_orders']; ?></div>
                            <div class="admin-stat-label">Total Orders</div>
                        </div>
                        
                        <div class="admin-stat">
                            <div class="admin-stat-icon">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                            <div class="admin-stat-value">৳<?php echo number_format($sales_report['total_revenue'], 2); ?></div>
                            <div class="admin-stat-label">Total Revenue</div>
                        </div>
                        
                        <div class="admin-stat">
                            <div class="admin-stat-icon">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="admin-stat-value">৳<?php echo number_format($sales_report['completed_revenue'], 2); ?></div>
                            <div class="admin-stat-label">Completed Orders</div>
                        </div>
                        
                        <div class="admin-stat">
                            <div class="admin-stat-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="admin-stat-value">৳<?php echo number_format($sales_report['pending_revenue'], 2); ?></div>
                            <div class="admin-stat-label">Pending Orders</div>
                        </div>
                    </div>
                    
                    <div class="chart-container">
                        <canvas id="salesChart"></canvas>
                    </div>
                </section>
                
                <section class="admin-section">
                    <div class="section-header">
                        <h2>Recent Orders</h2>
                    </div>
                    
                    <?php if (empty($recent_orders)): ?>
                        <p>No recent orders found.</p>
                    <?php else: ?>
                        <table class="admin-table">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>User</th>
                                    <th>Package</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_orders as $order): ?>
                                <tr>
                                    <td>#<?php echo $order['id']; ?></td>
                                    <td><?php echo htmlspecialchars($order['user_name']); ?></td>
                                    <td><?php echo htmlspecialchars($order['package_name']); ?></td>
                                    <td>৳<?php echo number_format($order['amount'], 2); ?></td>
                                    <td>
                                        <span class="status-badge <?php echo $order['status']; ?>">
                                            <?php echo ucfirst($order['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('M d, Y', strtotime($order['created_at'])); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </section>
                
                <section class="admin-section">
                    <div class="section-header">
                        <h2>Recent Users</h2>
                    </div>
                    
                    <?php if (empty($recent_users)): ?>
                        <p>No recent users found.</p>
                    <?php else: ?>
                        <table class="admin-table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Joined</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_users as $user): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($user['name']); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['phone']); ?></td>
                                    <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </section>
            </div>
        </main>
    </div>

    <script src="../assets/js/script.js"></script>
    <script>
        // Sales Chart
        const ctx = document.getElementById('salesChart').getContext('2d');
        const salesChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['Completed', 'Pending', 'Cancelled'],
                datasets: [{
                    label: 'Revenue (৳)',
                    data: [
                        <?php echo $sales_report['completed_revenue']; ?>,
                        <?php echo $sales_report['pending_revenue']; ?>,
                        0 // Assuming cancelled revenue is 0
                    ],
                    backgroundColor: [
                        'rgba(46, 204, 113, 0.7)',
                        'rgba(241, 196, 15, 0.7)',
                        'rgba(231, 76, 60, 0.7)'
                    ],
                    borderColor: [
                        'rgba(46, 204, 113, 1)',
                        'rgba(241, 196, 15, 1)',
                        'rgba(231, 76, 60, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>
</html>