<?php 
require_once '../includes/config.php';
requireAdmin();

// Handle package creation
if (isset($_POST['create_package'])) {
    $name = trim($_POST['name']);
    $description = trim($_POST['description']);
    $price = (float)$_POST['price'];
    $storage = trim($_POST['storage']);
    $bandwidth = trim($_POST['bandwidth']);
    $domains = (int)$_POST['domains'];
    $email_accounts = (int)$_POST['email_accounts'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    
    if (createPackage($name, $description, $price, $storage, $bandwidth, $domains, $email_accounts, $is_active)) {
        $_SESSION['success'] = "Package created successfully";
        header('Location: packages.php');
        exit();
    } else {
        $error = "Failed to create package";
    }
}

// Handle package update
if (isset($_POST['update_package'])) {
    $id = (int)$_POST['id'];
    $name = trim($_POST['name']);
    $description = trim($_POST['description']);
    $price = (float)$_POST['price'];
    $storage = trim($_POST['storage']);
    $bandwidth = trim($_POST['bandwidth']);
    $domains = (int)$_POST['domains'];
    $email_accounts = (int)$_POST['email_accounts'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    
    if (updatePackage($id, $name, $description, $price, $storage, $bandwidth, $domains, $email_accounts, $is_active)) {
        $_SESSION['success'] = "Package updated successfully";
        header('Location: packages.php');
        exit();
    } else {
        $error = "Failed to update package";
    }
}

// Get all packages
$packages = getPackages();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Packages - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="admin-content">
            <header class="admin-header">
                <h1>Manage Packages</h1>
                <div class="admin-user">
                    <span><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                    <div class="avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                </div>
            </header>
            
            <?php if (isset($_SESSION['success'])): ?>
                <div class="alert alert-success">
                    <p><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></p>
                </div>
            <?php endif; ?>
            
            <?php if (isset($error)): ?>
                <div class="alert alert-danger">
                    <p><?php echo $error; ?></p>
                </div>
            <?php endif; ?>
            
            <div class="admin-sections">
                <section class="admin-section">
                    <div class="section-header">
                        <h2>Create New Package</h2>
                    </div>
                    
                    <form action="packages.php" method="POST" class="admin-form">
                        <div class="admin-form-group">
                            <label for="name">Package Name</label>
                            <input type="text" id="name" name="name" required>
                        </div>
                        
                        <div class="admin-form-group">
                            <label for="description">Description</label>
                            <textarea id="description" name="description" rows="3"></textarea>
                        </div>
                        
                        <div class="admin-form-group">
                            <label for="price">Price (৳)</label>
                            <input type="number" id="price" name="price" step="0.01" min="0" required>
                        </div>
                        
                        <div class="form-row">
                            <div class="admin-form-group">
                                <label for="storage">Storage</label>
                                <input type="text" id="storage" name="storage" required>
                            </div>
                            
                            <div class="admin-form-group">
                                <label for="bandwidth">Bandwidth</label>
                                <input type="text" id="bandwidth" name="bandwidth" required>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="admin-form-group">
                                <label for="domains">Domains</label>
                                <input type="number" id="domains" name="domains" min="1" required>
                            </div>
                            
                            <div class="admin-form-group">
                                <label for="email_accounts">Email Accounts</label>
                                <input type="number" id="email_accounts" name="email_accounts" min="1" required>
                            </div>
                        </div>
                        
                        <div class="admin-form-group">
                            <label>
                                <input type="checkbox" name="is_active" checked>
                                Active
                            </label>
                        </div>
                        
                        <div class="admin-form-actions">
                            <button type="submit" name="create_package" class="btn btn-primary">Create Package</button>
                        </div>
                    </form>
                </section>
                
                <section class="admin-section">
                    <div class="section-header">
                        <h2>Existing Packages</h2>
                    </div>
                    
                    <?php if (empty($packages)): ?>
                        <p>No packages found.</p>
                    <?php else: ?>
                        <table class="admin-table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Price</th>
                                    <th>Storage</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($packages as $package): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($package['name']); ?></td>
                                    <td>৳<?php echo number_format($package['price'], 2); ?></td>
                                    <td><?php echo htmlspecialchars($package['storage']); ?></td>
                                    <td>
                                        <span class="status-badge <?php echo $package['is_active'] ? 'active' : 'inactive'; ?>">
                                            <?php echo $package['is_active'] ? 'Active' : 'Inactive'; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="edit-package.php?id=<?php echo $package['id']; ?>" class="btn btn-sm">Edit</a>
                                        <a href="delete-package.php?id=<?php echo $package['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </section>
            </div>
        </main>
    </div>

    <script src="../assets/js/script.js"></script>
</body>
</html>