<?php 
require_once '../includes/config.php';
requireAdmin();

// Handle admin settings update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // In a real application, you would validate and sanitize these inputs
    $site_name = $_POST['site_name'];
    $site_email = $_POST['site_email'];
    $currency = $_POST['currency'];
    $bkash_number = $_POST['bkash_number'];
    $nagad_number = $_POST['nagad_number'];
    $rocket_number = $_POST['rocket_number'];
    
    // Update settings in database (simplified example)
    try {
        $stmt = $pdo->prepare("UPDATE settings SET 
                              site_name = ?, 
                              site_email = ?, 
                              currency = ?, 
                              bkash_number = ?, 
                              nagad_number = ?, 
                              rocket_number = ? 
                              WHERE id = 1");
        $stmt->execute([$site_name, $site_email, $currency, $bkash_number, $nagad_number, $rocket_number]);
        
        $_SESSION['success'] = "Settings updated successfully";
    } catch (PDOException $e) {
        $error = "Error updating settings: " . $e->getMessage();
    }
}

// Get current settings
$settings = $pdo->query("SELECT * FROM settings LIMIT 1")->fetch();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Settings - Web Hosting Bangladesh</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <aside class="admin-sidebar">
            <div class="admin-logo">
                <a href="index.php"><img src="../assets/images/logo.png" alt="Hosting BD Logo"></a>
            </div>
            
            <nav class="admin-nav">
                <ul>
                    <li><a href="index.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
                    <li><a href="packages.php"><i class="fas fa-box"></i> Packages</a></li>
                    <li><a href="orders.php"><i class="fas fa-shopping-cart"></i> Orders</a></li>
                    <li><a href="users.php"><i class="fas fa-users"></i> Users</a></li>
                    <li><a href="reports.php"><i class="fas fa-chart-bar"></i> Reports</a></li>
                    <li class="active"><a href="admin.php"><i class="fas fa-cog"></i> Settings</a></li>
                    <li><a href="../logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                </ul>
            </nav>
        </aside>
        
        <main class="admin-content">
            <header class="admin-header">
                <h1>System Settings</h1>
                <div class="admin-user">
                    <span><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                    <div class="avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                </div>
            </header>
            
            <?php if (isset($_SESSION['success'])): ?>
                <div class="alert alert-success">
                    <p><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></p>
                </div>
            <?php endif; ?>
            
            <?php if (isset($error)): ?>
                <div class="alert alert-danger">
                    <p><?php echo $error; ?></p>
                </div>
            <?php endif; ?>
            
            <div class="admin-sections">
                <section class="admin-section">
                    <h2>General Settings</h2>
                    
                    <form action="admin.php" method="POST" class="admin-form">
                        <div class="admin-form-group">
                            <label for="site_name">Site Name</label>
                            <input type="text" id="site_name" name="site_name" value="<?php echo htmlspecialchars($settings['site_name']); ?>" required>
                        </div>
                        
                        <div class="admin-form-group">
                            <label for="site_email">Site Email</label>
                            <input type="email" id="site_email" name="site_email" value="<?php echo htmlspecialchars($settings['site_email']); ?>" required>
                        </div>
                        
                        <div class="admin-form-group">
                            <label for="currency">Currency</label>
                            <select id="currency" name="currency" required>
                                <option value="BDT" <?php echo $settings['currency'] === 'BDT' ? 'selected' : ''; ?>>Bangladeshi Taka (৳)</option>
                                <option value="USD" <?php echo $settings['currency'] === 'USD' ? 'selected' : ''; ?>>US Dollar ($)</option>
                            </select>
                        </div>
                        
                        <h3>Payment Gateway Settings</h3>
                        
                        <div class="admin-form-group">
                            <label for="bkash_number">bKash Number</label>
                            <input type="text" id="bkash_number" name="bkash_number" value="<?php echo htmlspecialchars($settings['bkash_number']); ?>">
                        </div>
                        
                        <div class="admin-form-group">
                            <label for="nagad_number">Nagad Number</label>
                            <input type="text" id="nagad_number" name="nagad_number" value="<?php echo htmlspecialchars($settings['nagad_number']); ?>">
                        </div>
                        
                        <div class="admin-form-group">
                            <label for="rocket_number">Rocket Number</label>
                            <input type="text" id="rocket_number" name="rocket_number" value="<?php echo htmlspecialchars($settings['rocket_number']); ?>">
                        </div>
                        
                        <div class="admin-form-actions">
                            <button type="submit" class="btn btn-primary">Save Settings</button>
                        </div>
                    </form>
                </section>
                
                <section class="admin-section">
                    <h2>System Information</h2>
                    
                    <div class="system-info">
                        <div class="info-row">
                            <span>PHP Version:</span>
                            <span><?php echo phpversion(); ?></span>
                        </div>
                        
                        <div class="info-row">
                            <span>MySQL Version:</span>
                            <span><?php echo $pdo->query('SELECT VERSION()')->fetchColumn(); ?></span>
                        </div>
                        
                        <div class="info-row">
                            <span>Server Software:</span>
                            <span><?php echo $_SERVER['SERVER_SOFTWARE']; ?></span>
                        </div>
                        
                        <div class="info-row">
                            <span>Database Size:</span>
                            <span>
                                <?php
                                $stmt = $pdo->query("SELECT 
                                    ROUND(SUM(data_length + index_length) / 1024 / 1024, 2) as size_mb
                                    FROM information_schema.tables 
                                    WHERE table_schema = DATABASE()");
                                echo $stmt->fetch()['size_mb'] . ' MB';
                                ?>
                            </span>
                        </div>
                    </div>
                </section>
            </div>
        </main>
    </div>

    <script src="../assets/js/script.js"></script>
</body>
</html>